#ifndef _ExtractDLG_CPP
#define _ExtractDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ShlObj.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Package.H"
#include "../Source/Entry.H"
#include "../Source/Common.H"
#include "../Source/FolderTree.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/PackingDlg.H"
#include "../Dialogs/NewFolderDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//---------------------(Variable Declarations)
HWND ExtractDialog_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ExtractDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static FolderTree MyFolderTree;

    static HMENU SystemMenu = NULL;

    static HWND AllFilesRadio_hWnd = NULL;
    static HWND BrowseTree_hWnd = NULL;
    static HWND ExtractToLocation_hWnd = NULL;
    static HWND OverwriteCB_hWnd = NULL;
    static HWND SelectedRadio_hWnd = NULL;
    static HWND SkipOlderFilesCB_hWnd = NULL;
    static HWND UseFolderNamesCB_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        ExtractDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        SelectedRadio_hWnd     = GetDlgItem(xHandle, IDC_SELECTEDRADIO);
        AllFilesRadio_hWnd     = GetDlgItem(xHandle, IDC_ALLRADIO);
        OverwriteCB_hWnd       = GetDlgItem(xHandle, IDC_OVERWRITE);
        SkipOlderFilesCB_hWnd  = GetDlgItem(xHandle, IDC_SKIPOLDER);
        UseFolderNamesCB_hWnd  = GetDlgItem(xHandle, IDC_USEFOLDERS);
        ExtractToLocation_hWnd = GetDlgItem(xHandle, IDC_DECRYPTLOCATION);
        BrowseTree_hWnd        = GetDlgItem(xHandle, IDC_BROWSETREE);

		InvalidateRect(BrowseTree_hWnd, NULL, 0);

        if(ListView_GetSelectedCount(FileList_hWnd) > 0)
        {
            CheckDlgButton(xHandle, IDC_SELECTEDRADIO, BST_CHECKED);
            CheckDlgButton(xHandle, IDC_ALLRADIO, BST_UNCHECKED);
            EnableWindow(SelectedRadio_hWnd, TRUE);
        }
        else {
            CheckDlgButton(xHandle, IDC_ALLRADIO, BST_CHECKED);
            CheckDlgButton(xHandle, IDC_SELECTEDRADIO, BST_UNCHECKED);
            EnableWindow(SelectedRadio_hWnd, FALSE);
        }

        if(strlen(gsLastExtractLocation) <= 0)
        {
            char InitialDirectory[MAX_PATH + 1];
            GetCurrentDirectory(MAX_PATH, InitialDirectory);
            Set_Text(ExtractToLocation_hWnd, InitialDirectory);
        }
        else Set_Text(ExtractToLocation_hWnd, gsLastExtractLocation);

        MyFolderTree.InitFolderTree(BrowseTree_hWnd, GetDlgItem(xHandle, IDC_DECRYPT), ExtractToLocation_hWnd);

        char FullPath[MAX_PATH + 1];
        char Drive[MAX_PATH + 1];
        char Dir[MAX_PATH + 1];

        _splitpath(gsArchiveName, Drive, Dir, NULL, NULL);
        _makepath(FullPath, Drive, Dir, NULL, NULL);
        MyFolderTree.SelectPath(FullPath);

        CenterWindow(xHandle);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(MyFolderTree.FolderTreeHandler(xHandle, xMessage, wParam, lParam))
    {
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
		if(wParam == IDC_NEWFOLDER)
        {
            int Length = Get_TextEx(ExtractToLocation_hWnd, gsExtractLocation, 255);
			if(Length > 0 || Length <= 255)
			{
				if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_NEWFOLDER), xHandle, NewFolderDialog) == 1)
				{
					char sNewPath[MAX_PATH + 1];
					_makepath(sNewPath, NULL, gsExtractLocation, sNewFolderName, NULL);
					strcat(sNewPath, "\\");
					CreateFolderStructure(sNewPath);

					//This is a bad way to refresh the treview.
					MyFolderTree.UnInitFolderTree();
					MyFolderTree.InitFolderTree(BrowseTree_hWnd, GetDlgItem(xHandle, IDC_DECRYPT), ExtractToLocation_hWnd);
					MyFolderTree.SelectPath(sNewPath);
				}
			}
			return TRUE;
		}

		if(wParam == IDC_GOTO)
        {
            int Length = Get_TextEx(ExtractToLocation_hWnd, gsExtractLocation, 255);
			if(Length > 0 || Length <= 255)
			{
				MyFolderTree.SelectPath(gsExtractLocation);
			}
			return TRUE;
		}

		if(wParam == IDC_DECRYPT)
        {
            int Length = Get_TextEx(ExtractToLocation_hWnd, gsExtractLocation, 255);
            if(Length <= 0 || Length > 255)
            {
                MessageBox(ExtractDialog_hWnd, "You must specifiy a location to extract the files to.", gsTitleCaption, 0);
                return TRUE;
            }

            if(gsExtractLocation[strlen(gsExtractLocation) - 1] != '\\')
            {
                strcat(gsExtractLocation, "\\");
            }

            if(IsDlgButtonChecked(xHandle, IDC_SELECTEDRADIO))
            {
                gdwCurrentJobType = JOB_TYPE_EXTRACTSEL;
            }
            else {
                gdwCurrentJobType = JOB_TYPE_EXTRACTALL;
            }

            MyFolderTree.UnInitFolderTree();
            EndDialog(xHandle, 1);

            return TRUE;
        }

        if(wParam == IDC_CANCEL)
        {
            MyFolderTree.UnInitFolderTree();
            EndDialog(xHandle, 0);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        MyFolderTree.UnInitFolderTree();
        EndDialog(xHandle, 0);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

